# SourceHub - Installation Guide for cPanel

## Quick Start

### Step 1: Upload Files to cPanel
1. Go to cPanel File Manager
2. Navigate to `public_html` folder
3. Upload all PHP files here

### Step 2: Create Database
1. Go to cPanel → MySQL Databases
2. Create new database: `sourcehub`
3. Create new user: `sourcehub_user` with password
4. Add user to database with ALL privileges

### Step 3: Update Database Credentials
Edit `config.php` and change:
```php
define('DB_USER', 'sourcehub_user');    // Your cPanel database user
define('DB_PASS', 'your_password');     // Your cPanel database password
```

### Step 4: Run Setup Test
1. Visit: `http://yoursite.com/setup.php`
2. If all tests pass, continue to next step
3. If tests fail, check the troubleshooting section

### Step 5: Access Your Site
Visit: `http://yoursite.com/index.php`

---

## File Structure
```
public_html/
├── .htaccess              (Server configuration)
├── config.php             (Database config)
├── index.php              (Homepage)
├── login.php              (Login page)
├── register.php           (Register page)
├── projects.php           (Projects list)
├── project.php            (Project details)
├── dashboard.php          (User dashboard)
├── admin.php              (Admin panel)
├── logout.php             (Logout handler)
├── setup.php              (Setup & test)
└── troubleshoot.php       (Debug page)
```

---

## Troubleshooting HTTP 500 Error

### Issue 1: Database Connection Failed
**Solution:**
1. Check cPanel MySQL Databases
2. Verify username and password
3. Update in `config.php`
4. Run setup.php to test

### Issue 2: PHP Version Error
**Solution:**
1. Go to cPanel → PHP Configuration
2. Switch to PHP 7.4 or higher
3. Clear browser cache
4. Reload page

### Issue 3: Table Not Found Error
**Solution:**
1. Visit setup.php
2. It will auto-create tables
3. Or manually check cPanel phpMyAdmin

### Issue 4: File Permissions
**Solution:**
1. In cPanel File Manager
2. Select all files
3. Right-click → Change Permissions
4. Set to 644 for files, 755 for folders

### Issue 5: Still Getting 500 Error
**Solution:**
1. Visit troubleshoot.php
2. Check PHP error logs in cPanel
3. Ask hosting provider to enable display_errors temporarily
4. Contact support with error log

---

## Demo Account
- Email: `admin@example.com`
- Password: `password`

---

## Features
✓ User Registration & Login
✓ Browse Digital Projects
✓ Purchase Projects
✓ User Dashboard
✓ Admin Panel with Statistics
✓ MySQL Database
✓ Responsive Design

---

## Support
For issues or questions:
1. Check setup.php first
2. Review troubleshoot.php
3. Contact hosting provider
4. Check error_log file in public_html

---

## Security Notes
- Change admin password after first login
- Use HTTPS in production
- Update database credentials to secure ones
- Backup your database regularly

---

**Last Updated:** November 25, 2025
